<?php
require 'conexion.php';
$codigo = $_GET['codigo'] ?? '';
$cert = null;
if($codigo){
    $stmt = $pdo->prepare("SELECT * FROM certificados WHERE codigo_unico = ?");
    $stmt->execute([$codigo]);
    $cert = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Validar Documento</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark d-flex align-items-center justify-content-center" style="min-height: 100vh;">
    <div class="card shadow-lg" style="width: 100%; max-width: 450px;">
        <?php if($cert): ?>
            <div class="card-header text-center text-white <?php echo $cert['estado'] == 'VIGENTE' ? 'bg-success' : 'bg-danger'; ?>">
                <h2 class="mb-0"><?php echo $cert['estado'] == 'VIGENTE' ? '✓ VÁLIDO' : '✕ ANULADO'; ?></h2>
            </div>
            <div class="card-body">
                <h5 class="text-center text-muted mb-4">Detalles del Certificado</h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item"><strong>Folio:</strong> N° <?= $cert['id'] ?></li>
                    <li class="list-group-item"><strong>Tipo:</strong> <?= $cert['tipo'] ?></li>
                    <li class="list-group-item"><strong>Empresa:</strong> <?= $cert['empresa_nombre'] ?></li>
                    <li class="list-group-item"><strong>Vehículo:</strong> <?= $cert['tipo_vehiculo'] ?> - <?= $cert['patente'] ?></li>
                    <li class="list-group-item"><strong>Fecha Emisión:</strong> <?= date('d-m-Y', strtotime($cert['fecha_emision'])) ?></li>
                    <li class="list-group-item text-center pt-3">
                        <small class="text-muted">Código de Verificación</small><br>
                        <span class="h4 text-primary letter-spacing-2"><?= $cert['codigo_unico'] ?></span>
                    </li>
                </ul>
            </div>
        <?php else: ?>
            <div class="card-header bg-warning text-center">
                <h2 class="mb-0">⚠ NO ENCONTRADO</h2>
            </div>
            <div class="card-body text-center">
                <p>El código escaneado no existe en nuestros registros.</p>
                <h3 class="text-muted"><?= htmlspecialchars($codigo) ?></h3>
            </div>
        <?php endif; ?>
        <div class="card-footer text-center text-muted small">
            Sistema de Validación JSantos SpA
        </div>
    </div>
</body>
</html>