<?php
require 'conexion.php';

// --- CONFIGURACIÓN ---
$CLAVE_MAESTRA = "JSANTOS2025"; // <--- CAMBIA ESTO POR TU CÓDIGO SECRETO
// ---------------------

$mensaje = '';
$tipo_alerta = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user = $_POST['username'];
    $codigo = $_POST['codigo_seguridad'];
    $new_pass = $_POST['new_password'];

    // 1. Validar Clave Maestra
    if ($codigo === $CLAVE_MAESTRA) {
        
        // 2. Verificar que el usuario existe
        $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE username = ?");
        $stmt->execute([$user]);
        if ($stmt->fetch()) {
            // 3. Actualizar contraseña
            $hash = password_hash($new_pass, PASSWORD_DEFAULT);
            $update = $pdo->prepare("UPDATE usuarios SET password = ? WHERE username = ?");
            $update->execute([$hash, $user]);

            $mensaje = "¡Contraseña actualizada con éxito! Ahora puedes ingresar.";
            $tipo_alerta = "success";
        } else {
            $mensaje = "El usuario ingresado no existe.";
            $tipo_alerta = "danger";
        }

    } else {
        $mensaje = "Código de seguridad incorrecto.";
        $tipo_alerta = "danger";
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Restablecer Contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #e9ecef; display: flex; align-items: center; justify-content: center; height: 100vh; }
        .card-reset { width: 100%; max-width: 400px; border-radius: 15px; overflow: hidden; box-shadow: 0 10px 25px rgba(0,0,0,0.1); }
        .header-reset { background-color: #dc3545; padding: 20px; text-align: center; color: white; } /* Rojo para indicar zona sensible */
        .logo-small { width: 80px; filter: brightness(0) invert(1); margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="card-reset bg-white">
        <div class="header-reset">
            <img src="assets/logo.png" class="logo-small" alt="Logo"><br>
            <h5 class="mb-0">Restablecer Acceso</h5>
        </div>
        
        <div class="card-body p-4">
            <?php if($mensaje): ?>
                <div class="alert alert-<?= $tipo_alerta ?> text-center"><?= $mensaje ?></div>
                <?php if($tipo_alerta == 'success'): ?>
                    <a href="login.php" class="btn btn-dark w-100 mt-2">Ir al Login</a>
                    <?php exit; // Detenemos la carga del formulario ?>
                <?php endif; ?>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label class="form-label small text-muted">Usuario a recuperar</label>
                    <input type="text" name="username" class="form-control" placeholder="ej: admin" required>
                </div>

                <div class="mb-3">
                    <label class="form-label small text-muted">Nueva Contraseña</label>
                    <input type="password" name="new_password" class="form-control" placeholder="Nueva clave" required>
                </div>

                <div class="mb-4">
                    <label class="form-label small fw-bold text-danger">Código Maestro de Seguridad</label>
                    <input type="password" name="codigo_seguridad" class="form-control border-danger" placeholder="Código entregado por soporte" required>
                </div>

                <button type="submit" class="btn btn-danger w-100">Cambiar Contraseña</button>
                <div class="text-center mt-3">
                    <a href="login.php" class="text-muted small text-decoration-none">← Volver al Login</a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>