<?php
session_start();
require 'conexion.php';

$error = '';

// Lógica de Login
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user = $_POST['username'];
    $pass = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE username = ?");
    $stmt->execute([$user]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verificar contraseña
    if ($usuario && password_verify($pass, $usuario['password'])) {
        $_SESSION['usuario_id'] = $usuario['id'];
        $_SESSION['usuario_nombre'] = $usuario['username'];
        header("Location: index.php");
        exit;
    } else {
        $error = "Usuario o contraseña incorrectos";
    }
}

// AUTO-INSTALACIÓN (Solo para la primera vez)
// Si la tabla está vacía, crea el usuario admin / admin123 automáticamente
$check = $pdo->query("SELECT COUNT(*) FROM usuarios")->fetchColumn();
if($check == 0){
    $passHash = password_hash('admin123', PASSWORD_DEFAULT);
    $pdo->prepare("INSERT INTO usuarios (username, password) VALUES ('admin', ?)")->execute([$passHash]);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Login - JSantos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #e9ecef; display: flex; align-items: center; justify-content: center; height: 100vh; }
        .login-card { width: 100%; max-width: 400px; border-radius: 15px; overflow: hidden; box-shadow: 0 10px 25px rgba(0,0,0,0.1); }
        .login-header { background-color: #1a3c6e; padding: 30px 20px; text-align: center; }
        .login-logo { width: 150px; filter: brightness(0) invert(1); /* Vuelve el logo blanco */ }
    </style>
</head>
<body>
    <div class="login-card bg-white">
        <div class="login-header">
            <!-- LOGO EN EL LOGIN -->
            <img src="assets/logo.png" class="login-logo" alt="JSantos Logo">
            <h5 class="text-white mt-3 mb-0 fw-light">Acceso al Sistema</h5>
        </div>
        <div class="card-body p-4">
            <?php if($error): ?>
                <div class="alert alert-danger text-center py-2"><?= $error ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label text-muted">Usuario</label>
                    <input type="text" name="username" class="form-control form-control-lg" placeholder="admin" required autofocus>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Contraseña</label>
                    <input type="password" name="password" class="form-control form-control-lg" placeholder="admin123" required>
                </div>
                <button type="submit" class="btn btn-primary w-100 btn-lg mt-2" style="background-color: #2E7D32; border:none;">Ingresar</button>
            </form>
            <div class="text-center mt-3">
                <a href="recuperar.php" class="text-muted small" style="text-decoration: none;">¿Olvidaste tu contraseña?</a>
            </div>
        </div>
        <div class="card-footer text-center bg-light py-3">
            <small class="text-muted">Sistema de Certificados v2.0</small>
        </div>
    </div>
</body>
</html>