<?php
// 1. SEGURIDAD DE SESIÓN
session_start();
if (!isset($_SESSION['usuario_id'])) {
    header("Location: login.php");
    exit;
}

require 'conexion.php';

// Lógica Anular/Restaurar
if (isset($_GET['anular'])) {
    $stmt = $pdo->prepare("UPDATE certificados SET estado = 'ANULADO' WHERE id = ?");
    $stmt->execute([$_GET['anular']]);
    header("Location: index.php"); exit;
}
if (isset($_GET['restaurar'])) {
    $stmt = $pdo->prepare("UPDATE certificados SET estado = 'VIGENTE' WHERE id = ?");
    $stmt->execute([$_GET['restaurar']]);
    header("Location: index.php"); exit;
}

// Listar
$stmt = $pdo->query("SELECT * FROM certificados ORDER BY id DESC");
$certificados = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel de Control - JSantos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .hidden { display: none; }
        .navbar-brand img { height: 40px; margin-right: 10px; }
        .bg-brand { background-color: #1a3c6e; }
    </style>
</head>
<body class="bg-light">
    
    <!-- NAVBAR CON LOGO Y BOTÓN SALIR -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-brand mb-4 shadow-sm">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="#">
                <!-- LOGO EN EL DASHBOARD -->
                <img src="assets/logo.png" style="filter: brightness(0) invert(1);" alt="Logo"> 
                <span>Sistema de Certificados</span>
            </a>
            <div class="d-flex align-items-center">
                <span class="text-white me-3">Hola, <strong><?= strtoupper($_SESSION['usuario_nombre']) ?></strong></span>
                <a href="logout.php" class="btn btn-outline-light btn-sm">Cerrar Sesión</a>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="row">
            <!-- FORMULARIO -->
            <div class="col-md-5">
                <div class="card shadow border-0">
                    <div class="card-header bg-secondary text-white fw-bold">
                        <i class="bi bi-plus-circle"></i> Nuevo Documento
                    </div>
                    <div class="card-body bg-white">
                        <form action="guardar.php" method="POST">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted small">TIPO DE CERTIFICADO</label>
                                <select name="tipo" id="tipoSelect" class="form-select" onchange="toggleFields()" required>
                                    <option value="OPERATIVIDAD">Certificado de Operatividad</option>
                                    <option value="MANTENCION">Certificado de Mantención</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="small text-muted">Fecha de Emisión</label>
                                <input type="date" name="fecha_emision" class="form-control" value="<?= date('Y-m-d') ?>" required>
                            </div>

                            <h6 class="text-primary border-bottom pb-1 mb-3 small fw-bold">DATOS DEL CLIENTE</h6>
                            <div class="row g-2 mb-2">
                                <div class="col"><input type="text" name="empresa_nombre" class="form-control form-control-sm" placeholder="Nombre Empresa" required></div>
                                <div class="col"><input type="text" name="empresa_rut" class="form-control form-control-sm" placeholder="RUT" required></div>
                            </div>

                            <h6 class="text-primary border-bottom pb-1 mb-3 mt-3 small fw-bold">DATOS DEL VEHÍCULO</h6>
                            <input type="text" name="tipo_vehiculo" class="form-control form-control-sm mb-2" placeholder="Tipo Vehículo (ej: Camioneta)" required>
                            <div class="row g-2 mb-2">
                                <div class="col"><input type="text" name="marca" class="form-control form-control-sm" placeholder="Marca" required></div>
                                <div class="col"><input type="text" name="modelo" class="form-control form-control-sm" placeholder="Modelo" required></div>
                                <div class="col"><input type="number" name="anio" class="form-control form-control-sm" placeholder="Año" required></div>
                            </div>
                            <div class="row g-2 mb-2">
                                <div class="col"><input type="text" name="patente" class="form-control form-control-sm" placeholder="Patente" required></div>
                                <div class="col"><input type="text" name="kilometraje" class="form-control form-control-sm" placeholder="KM Actual" required></div>
                            </div>
                            <div class="row g-2 mb-2">
                                <div class="col"><input type="text" name="motor" class="form-control form-control-sm" placeholder="N° Motor" required></div>
                                <div class="col"><input type="text" name="chasis" class="form-control form-control-sm" placeholder="N° Chasis" required></div>
                            </div>

                            <!-- CAMPOS VARIABLES -->
                            <div id="campoOperatividad" class="p-3 bg-light border rounded mt-3">
                                <label class="small fw-bold">Fecha de Revisión</label>
                                <input type="date" name="fecha_revision" class="form-control form-control-sm">
                            </div>

                            <div id="campoMantencion" class="hidden p-3 bg-info bg-opacity-10 border border-info rounded mt-3">
                                <h6 class="small fw-bold text-primary">DETALLES MANTENCIÓN</h6>
                                <input type="date" name="fecha_mantencion" class="form-control form-control-sm mb-2" title="Fecha Mantención">
                                <input type="text" name="pauta" class="form-control form-control-sm mb-2" placeholder="Pauta (ej: 10.000 km)">
                                <input type="text" name="ot" class="form-control form-control-sm mb-2" placeholder="Número OT">
                                <div class="row g-1 mb-2">
                                    <div class="col"><input type="text" name="km_mantencion" class="form-control form-control-sm" placeholder="KM Mantención"></div>
                                    <div class="col"><input type="text" name="km_proxima" class="form-control form-control-sm" placeholder="Próxima Mant."></div>
                                </div>
                                <textarea name="observaciones" class="form-control form-control-sm" rows="2" placeholder="Observaciones..."></textarea>
                            </div>

                            <button type="submit" class="btn btn-success w-100 mt-4 py-2 fw-bold">EMITIR CERTIFICADO</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- LISTADO -->
            <div class="col-md-7">
                <div class="card shadow border-0">
                    <div class="card-header bg-white fw-bold">Historial de Emisiones</div>
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover align-middle text-center mb-0">
                            <thead class="table-light text-secondary small">
                                <tr>
                                    <th>FOLIO</th>
                                    <th>PATENTE</th>
                                    <th>TIPO</th>
                                    <th>ESTADO</th>
                                    <th>ACCIONES</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($certificados as $c): ?>
                                <tr>
                                    <td class="fw-bold">#<?= $c['id'] ?></td>
                                    <td><?= $c['patente'] ?></td>
                                    <td><small class="text-muted"><?= substr($c['tipo'], 0, 4) ?>...</small></td>
                                    <td>
                                        <?php if($c['estado'] == 'VIGENTE'): ?>
                                            <span class="badge rounded-pill bg-success">Activo</span>
                                        <?php else: ?>
                                            <span class="badge rounded-pill bg-danger">Anulado</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="generar_pdf.php?id=<?= $c['id'] ?>" target="_blank" class="btn btn-sm btn-primary" title="PDF">📄</a>
                                        <?php if($c['estado'] == 'VIGENTE'): ?>
                                            <a href="index.php?anular=<?= $c['id'] ?>" onclick="return confirm('¿Anular?')" class="btn btn-sm btn-outline-danger">✕</a>
                                        <?php else: ?>
                                            <a href="index.php?restaurar=<?= $c['id'] ?>" onclick="return confirm('¿Restaurar?')" class="btn btn-sm btn-outline-success">↻</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function toggleFields() {
            const tipo = document.getElementById('tipoSelect').value;
            if(tipo === 'MANTENCION'){
                document.getElementById('campoMantencion').classList.remove('hidden');
                document.getElementById('campoOperatividad').classList.add('hidden');
            } else {
                document.getElementById('campoMantencion').classList.add('hidden');
                document.getElementById('campoOperatividad').classList.remove('hidden');
            }
        }
        toggleFields();
    </script>
</body>
</html>