<?php
session_start();
if (!isset($_SESSION['usuario_id'])) {
    // Si intenta guardar sin sesión, lo botamos al login
    header("Location: login.php");
    exit;
}

require 'conexion.php';
// ... resto del código ...

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // 1. Generar Código 10 Caracteres
    $chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $codigo_unico = substr(str_shuffle(str_repeat($chars, 5)), 0, 10);

    // 2. Recopilar datos
    $fecha_rev = !empty($_POST['fecha_revision']) ? $_POST['fecha_revision'] : null;
    $fecha_mant = !empty($_POST['fecha_mantencion']) ? $_POST['fecha_mantencion'] : null;
    // Nuevo campo observaciones
    $observaciones = !empty($_POST['observaciones']) ? $_POST['observaciones'] : null;

    $sql = "INSERT INTO certificados (
        codigo_unico, tipo, fecha_emision,
        empresa_nombre, empresa_rut, tipo_vehiculo, marca, modelo, anio, patente, nro_motor, nro_chasis, kilometraje_actual,
        fecha_revision, fecha_mantencion, pauta_mantencion, numero_ot, km_mantencion, km_proxima, observaciones
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $pdo->prepare($sql);
    
    try {
        $stmt->execute([
            $codigo_unico, $_POST['tipo'], $_POST['fecha_emision'],
            $_POST['empresa_nombre'], $_POST['empresa_rut'], $_POST['tipo_vehiculo'], $_POST['marca'],
            $_POST['modelo'], $_POST['anio'], $_POST['patente'], $_POST['motor'], $_POST['chasis'], $_POST['kilometraje'],
            $fecha_rev, $fecha_mant, $_POST['pauta'], $_POST['ot'], $_POST['km_mantencion'], $_POST['km_proxima'], $observaciones
        ]);
        header("Location: index.php?status=success");
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}