<?php
require 'vendor/autoload.php';
require 'conexion.php';

use Mpdf\Mpdf;

// 1. VALIDACIÓN
if (!isset($_GET['id'])) die("Error: ID no especificado.");
$stmt = $pdo->prepare("SELECT * FROM certificados WHERE id = ?");
$stmt->execute([$_GET['id']]);
$cert = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$cert) die("Certificado no encontrado.");

// 2. RUTAS ABSOLUTAS
$ruta_fondo = __DIR__ . '/assets/fondo.jpg';
$ruta_firma = __DIR__ . '/assets/firma.png';
$ruta_logo  = __DIR__ . '/assets/logo.png';

if(!file_exists($ruta_fondo)) $ruta_fondo = ''; 
if(!file_exists($ruta_firma)) $ruta_firma = ''; 

// 3. FECHA ESPAÑOL
$meses = [1=>'Enero',2=>'Febrero',3=>'Marzo',4=>'Abril',5=>'Mayo',6=>'Junio',7=>'Julio',8=>'Agosto',9=>'Septiembre',10=>'Octubre',11=>'Noviembre',12=>'Diciembre'];
$timestamp = strtotime($cert['fecha_emision']);
$fecha_texto = date('d', $timestamp) . " de " . $meses[(int)date('n', $timestamp)] . " de " . date('Y', $timestamp);

// 4. URL QR
$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
$host_url = "$protocol://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
$host_url = rtrim(str_replace('\\', '/', $host_url), '/');

$url_qr_link = $host_url . "/validar.php?codigo=" . $cert['codigo_unico'];
$url_texto_visible = $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/validar.php";
$url_texto_visible = str_replace('\\', '/', $url_texto_visible);

// 5. CSS
$css = '
    body { font-family: Arial, sans-serif; font-size: 11pt; color: #000;
        background-image: url("'.$ruta_fondo.'"); background-image-resize: 6; background-repeat: no-repeat; }
    
    .bar-left-green { position: fixed; left: 0; top: 0; bottom: 0; width: 25px; background-color: #2E7D32; z-index: -1; }
    .bar-left-blue  { position: fixed; left: 25px; top: 50px; bottom: 10%; width: 15px; background-color: #1F4E79; z-index: -1; }
    .bar-right-blue { position: fixed; right: 0; top: 0; bottom: 0; width: 25px; background-color: #1F4E79; z-index: -1; }
    .bar-right-green{ position: fixed; right: 25px; top: 0; bottom: 50px; width: 15px; background-color: #2E7D32; z-index: -1; }
    
    .container { margin: 0 60px; padding-top: 20px; }
    .header { text-align: right; font-size: 10pt; margin-bottom: 30px; color: #333; }
    .logo-img { width: 180px; }
    h1 { text-align: center; text-transform: uppercase; font-size: 16pt; margin-top: 20px; margin-bottom: 10px; }
    .correlativo { text-align: center; font-weight: bold; text-decoration: underline; margin-bottom: 20px; font-size: 12pt; }
    
    p, li { text-align: justify; line-height: 1.1; margin-bottom: 8px; }
    
    table.info { width: 100%; border-collapse: collapse; margin: 15px 0; }
    table.info th, table.info td { border: 1px solid #000; padding: 6px; text-align: center; font-size: 10pt; }
    table.info th { background-color: #ddd; }
    
    .img-firma { width: 150px; position: relative; top: 15px; z-index: 5; }
    
    /* CAMBIO 1: Se eliminó el border-top (la línea) */
    .linea-firma { 
        border-top: none; 
        width: 200px; margin: 0 auto; padding-top: 5px; font-weight: bold; 
    }
    
    .watermark { position: fixed; top: 40%; left: 20%; font-size: 100px; color: rgba(255,0,0,0.2); transform: rotate(-45deg); font-weight: bold; z-index: 0; }

    .footer-url {
        position: fixed; bottom: 20px; left: 0px; right: 0px; width: 100%;
        text-align: center; font-size: 8pt; color: #555; font-family: monospace;
    }
';

// 6. HTML
$html = '
<body>
    <div class="bar-left-green"></div> <div class="bar-left-blue"></div>
    <div class="bar-right-blue"></div> <div class="bar-right-green"></div>
    '.($cert['estado'] == 'ANULADO' ? '<div class="watermark">ANULADO</div>' : '').'

    <div class="container">
        <table width="100%" style="border: none;">
            <tr>
                <td width="50%" align="left"><img src="'.$ruta_logo.'" class="logo-img" /></td>
                <td width="50%" align="right">
                    <div class="header">
                        <strong>SERVICIOS GENERALES SANTOS SpA.</strong><br>
                        RUT: 77.956.944-6<br>
                        Celular: +56 9 75436468<br>
                        Email: contacto@jsantos.cl<br><br>
                        Iquique, <strong>'.$fecha_texto.'</strong>
                    </div>
                </td>
            </tr>
        </table>

        <h1>CERTIFICADO DE '.str_replace('_', ' ', $cert['tipo']).'</h1>
        <div class="correlativo">N° '.$cert['id'].'</div>

        <p>
            <strong>SERVICIOS GENERALES SANTOS SpA.</strong> con RUT: <strong>77.956.944-6</strong>, certifica que el vehículo
            individualizado a continuación de propiedad de: <strong>'.strtoupper($cert['empresa_nombre']).'</strong>, 
            con RUT: <strong>'.$cert['empresa_rut'].'</strong>
        </p>';

if ($cert['tipo'] == 'OPERATIVIDAD') {
    $html .= '
        <ul>
            <li>Tipo de vehículo: <strong>'.$cert['tipo_vehiculo'].'</strong></li>
            <li>Kilometraje: <strong>'.$cert['kilometraje_actual'].'</strong></li>
        </ul>
        <table class="info">
            <tr><th>Marca</th> <th>Modelo</th> <th>Año</th> <th>Patente</th></tr>
            <tr><td>'.$cert['marca'].'</td> <td>'.$cert['modelo'].'</td> <td>'.$cert['anio'].'</td> <td>'.$cert['patente'].'</td></tr>
            <tr><th colspan="2">N° Motor</th> <th colspan="2">N° Chasis</th></tr>
            <tr><td colspan="2">'.$cert['nro_motor'].'</td> <td colspan="2">'.$cert['nro_chasis'].'</td></tr>
        </table>
        <p>Fue sometido previamente a una revisión exhaustiva contenidas en la Pauta de inspección estipulada por el fabricante y a la fecha de su revisión, se encuentra en buenas condiciones y puede operar con normalidad.</p>
        <p>Además de certificar que la unidad cuenta con su mantención al día y todos sus componentes mecánicos, eléctricos e hidráulicos en perfectas condiciones.</p>
    ';
} else {
    $html .= '
        <p>Tipo de vehículo <strong>'.$cert['tipo_vehiculo'].'</strong> con PPU <strong>['.$cert['patente'].']</strong>, de marca <strong>'.$cert['marca'].'</strong>, modelo <strong>'.$cert['modelo'].'</strong>, año <strong>'.$cert['anio'].'</strong>...</p>
        <br>
        <p>Fecha de mantención: <strong>'.($cert['fecha_mantencion'] ? date('d-m-Y', strtotime($cert['fecha_mantencion'])) : 'N/A').'</strong></p>
        <p>Pauta: <strong>'.$cert['pauta_mantencion'].'</strong></p>
        <p>Orden de Trabajo: <strong>OT: '.$cert['numero_ot'].'</strong></p>
        <p>Kilometraje: <strong>'.$cert['km_mantencion'].'</strong></p>
        <p>Próxima mantención: <strong>'.$cert['km_proxima'].'</strong></p>
    ';
    if (!empty($cert['observaciones'])) {
        $html .= '<br><p><strong>Observaciones:</strong><br>'.nl2br($cert['observaciones']).'</p>';
    }
}

$html .= '
        <br><p>Se extiende el presente certificado a solicitud del interesado sin ulterior responsabilidad para nuestra empresa ni para quien firma el presente documento.</p>
        <br><br>

        <table width="100%" style="border: none; margin-top: 20px;">
            <tr>
                <td width="15%"></td>
                <td width="50%" align="center" style="vertical-align: bottom;">
                    '.($ruta_firma ? '<img src="'.$ruta_firma.'" class="img-firma" /><br>' : '<br><br>').'
                    <div class="linea-firma">SERVICIOS GENERALES<br>JSANTOS SpA.</div>
                </td>
                <td width="35%" align="center" style="vertical-align: bottom;">
                     <div style="border: 3px solid #000; padding: 10px; width: 90px; margin: 0 auto;">
                        <barcode code="'.$url_qr_link.'" type="QR" class="barcode" size="0.8" error="M" disableborder="1" />
                     </div>
                     
                     <!-- CAMBIO 2: Espaciado agregado (margin-top: 15px) y cambio de texto -->
                     <div style="text-align: center; margin-top: 15px; font-size: 9pt;">
                        <strong>Código de Verificación</strong><br>
                        <span style="font-family:monospace; letter-spacing: 1px; color: #000;">'.$cert['codigo_unico'].'</span>
                     </div>
                </td>
            </tr>
        </table>
    </div>

    <div class="footer-url">
        Validar documento en: '.$url_texto_visible.'
    </div>
</body>';

try {
    $mpdf = new Mpdf(['mode'=>'utf-8', 'format'=>'Letter', 'margin_left'=>0, 'margin_right'=>0, 'margin_top'=>0, 'margin_bottom'=>0]);
    $mpdf->WriteHTML($css, \Mpdf\HTMLParserMode::HEADER_CSS);
    $mpdf->WriteHTML($html, \Mpdf\HTMLParserMode::HTML_BODY);
    $mpdf->Output('Certificado_'.$cert['id'].'.pdf', 'I');
} catch (\Mpdf\MpdfException $e) { echo "Error PDF: " . $e->getMessage(); }